/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.font;

import icyllis.modernui.graphics.font.FontMetricsInt;
import icyllis.modernui.graphics.font.FontPaint;
import icyllis.modernui.graphics.font.GlyphManager;
import icyllis.modernui.graphics.font.GraphemeMetrics;
import icyllis.modernui.text.FontCollection;
import java.awt.Font;
import java.awt.font.GlyphVector;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public class MeasureEngine {
    private static MeasureEngine sInstance;
    private final GlyphManager mGlyphManager = GlyphManager.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MeasureEngine getInstance() {
        if (sInstance != null) return sInstance;
        Class<MeasureEngine> clazz = MeasureEngine.class;
        synchronized (MeasureEngine.class) {
            if (sInstance != null) return sInstance;
            sInstance = new MeasureEngine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(@Nonnull char[] text, int contextStart, int contextEnd, @Nonnull FontPaint paint, boolean isRtl, @Nonnull BiConsumer<GraphemeMetrics, FontPaint> consumer) {
        List<FontCollection.Run> runs = paint.mFontCollection.itemize(text, contextStart, contextEnd);
        int flag = isRtl ? 1 : 0;
        GlyphManager manager = this.mGlyphManager;
        float advance = 0.0f;
        FontMetricsInt fm = new FontMetricsInt();
        for (FontCollection.Run run : runs) {
            Font derivedFont;
            MeasureEngine measureEngine = this;
            synchronized (measureEngine) {
                derivedFont = manager.deriveFont(run.getFamily(), paint.mFontStyle, paint.mFontSize);
            }
            GlyphVector vector = manager.layoutGlyphVector(derivedFont, text, run.getStart(), run.getEnd(), flag);
            int num = vector.getNumGlyphs();
            advance = (float)((double)advance + vector.getGlyphPosition(num).getX());
            manager.getFontMetrics(derivedFont, fm);
        }
        consumer.accept(new GraphemeMetrics(advance, fm), paint);
    }
}

